package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  DescriptionString,
  QueryString,
  WorkGroupName,
  StatementName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePreparedStatementRequest(
    statementName: StatementName,
    workGroup: WorkGroupName,
    queryStatement: QueryString,
    description: Optional[DescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest = {
    import UpdatePreparedStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest
      .builder()
      .statementName(StatementName.unwrap(statementName): java.lang.String)
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .queryStatement(QueryString.unwrap(queryStatement): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UpdatePreparedStatementRequest.ReadOnly =
    zio.aws.athena.model.UpdatePreparedStatementRequest.wrap(buildAwsValue())
}
object UpdatePreparedStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UpdatePreparedStatementRequest =
      zio.aws.athena.model.UpdatePreparedStatementRequest(
        statementName,
        workGroup,
        queryStatement,
        description.map(value => value)
      )
    def statementName: StatementName
    def workGroup: WorkGroupName
    def queryStatement: QueryString
    def description: Optional[DescriptionString]
    def getStatementName: ZIO[Any, Nothing, StatementName] =
      ZIO.succeed(statementName)
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getQueryStatement: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryStatement)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest
  ) extends zio.aws.athena.model.UpdatePreparedStatementRequest.ReadOnly {
    override val statementName: StatementName =
      zio.aws.athena.model.primitives.StatementName(impl.statementName())
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val queryStatement: QueryString =
      zio.aws.athena.model.primitives.QueryString(impl.queryStatement())
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest
  ): zio.aws.athena.model.UpdatePreparedStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
