package zio.aws.athena.model
import zio.aws.athena.model.primitives.{SessionManagerToken, SessionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListExecutorsResponse(
    sessionId: SessionId,
    nextToken: Optional[SessionManagerToken] = Optional.Absent,
    executorsSummary: Optional[
      Iterable[zio.aws.athena.model.ExecutorsSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListExecutorsResponse = {
    import ListExecutorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListExecutorsResponse
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          SessionManagerToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        executorsSummary.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.executorsSummary)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListExecutorsResponse.ReadOnly =
    zio.aws.athena.model.ListExecutorsResponse.wrap(buildAwsValue())
}
object ListExecutorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListExecutorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListExecutorsResponse =
      zio.aws.athena.model.ListExecutorsResponse(
        sessionId,
        nextToken.map(value => value),
        executorsSummary.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sessionId: SessionId
    def nextToken: Optional[SessionManagerToken]
    def executorsSummary
        : Optional[List[zio.aws.athena.model.ExecutorsSummary.ReadOnly]]
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getNextToken: ZIO[Any, AwsError, SessionManagerToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getExecutorsSummary: ZIO[Any, AwsError, List[
      zio.aws.athena.model.ExecutorsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("executorsSummary", executorsSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListExecutorsResponse
  ) extends zio.aws.athena.model.ListExecutorsResponse.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
    override val nextToken: Optional[SessionManagerToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.athena.model.primitives.SessionManagerToken(value)
        )
    override val executorsSummary
        : Optional[List[zio.aws.athena.model.ExecutorsSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executorsSummary())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.ExecutorsSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListExecutorsResponse
  ): zio.aws.athena.model.ListExecutorsResponse.ReadOnly = new Wrapper(impl)
}
