package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNotebookMetadataResponse(
    notebookMetadata: Optional[zio.aws.athena.model.NotebookMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse = {
    import GetNotebookMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse
      .builder()
      .optionallyWith(notebookMetadata.map(value => value.buildAwsValue()))(
        _.notebookMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly =
    zio.aws.athena.model.GetNotebookMetadataResponse.wrap(buildAwsValue())
}
object GetNotebookMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetNotebookMetadataResponse =
      zio.aws.athena.model.GetNotebookMetadataResponse(
        notebookMetadata.map(value => value.asEditable)
      )
    def notebookMetadata
        : Optional[zio.aws.athena.model.NotebookMetadata.ReadOnly]
    def getNotebookMetadata
        : ZIO[Any, AwsError, zio.aws.athena.model.NotebookMetadata.ReadOnly] =
      AwsError.unwrapOptionField("notebookMetadata", notebookMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse
  ) extends zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly {
    override val notebookMetadata
        : Optional[zio.aws.athena.model.NotebookMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookMetadata())
        .map(value => zio.aws.athena.model.NotebookMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse
  ): zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly = new Wrapper(
    impl
  )
}
