package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNamedQueryResponse(
    namedQuery: Optional[zio.aws.athena.model.NamedQuery] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetNamedQueryResponse = {
    import GetNamedQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetNamedQueryResponse
      .builder()
      .optionallyWith(namedQuery.map(value => value.buildAwsValue()))(
        _.namedQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetNamedQueryResponse.ReadOnly =
    zio.aws.athena.model.GetNamedQueryResponse.wrap(buildAwsValue())
}
object GetNamedQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetNamedQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetNamedQueryResponse =
      zio.aws.athena.model
        .GetNamedQueryResponse(namedQuery.map(value => value.asEditable))
    def namedQuery: Optional[zio.aws.athena.model.NamedQuery.ReadOnly]
    def getNamedQuery
        : ZIO[Any, AwsError, zio.aws.athena.model.NamedQuery.ReadOnly] =
      AwsError.unwrapOptionField("namedQuery", namedQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetNamedQueryResponse
  ) extends zio.aws.athena.model.GetNamedQueryResponse.ReadOnly {
    override val namedQuery
        : Optional[zio.aws.athena.model.NamedQuery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namedQuery())
        .map(value => zio.aws.athena.model.NamedQuery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetNamedQueryResponse
  ): zio.aws.athena.model.GetNamedQueryResponse.ReadOnly = new Wrapper(impl)
}
