package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  RoleArn,
  NameString,
  BytesScannedCutoffValue,
  BoxedBoolean
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkGroupConfigurationUpdates(
    enforceWorkGroupConfiguration: Optional[BoxedBoolean] = Optional.Absent,
    resultConfigurationUpdates: Optional[
      zio.aws.athena.model.ResultConfigurationUpdates
    ] = Optional.Absent,
    publishCloudWatchMetricsEnabled: Optional[BoxedBoolean] = Optional.Absent,
    bytesScannedCutoffPerQuery: Optional[BytesScannedCutoffValue] =
      Optional.Absent,
    removeBytesScannedCutoffPerQuery: Optional[BoxedBoolean] = Optional.Absent,
    requesterPaysEnabled: Optional[BoxedBoolean] = Optional.Absent,
    engineVersion: Optional[zio.aws.athena.model.EngineVersion] =
      Optional.Absent,
    removeCustomerContentEncryptionConfiguration: Optional[BoxedBoolean] =
      Optional.Absent,
    additionalConfiguration: Optional[NameString] = Optional.Absent,
    executionRole: Optional[RoleArn] = Optional.Absent,
    customerContentEncryptionConfiguration: Optional[
      zio.aws.athena.model.CustomerContentEncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates = {
    import WorkGroupConfigurationUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
      .builder()
      .optionallyWith(
        enforceWorkGroupConfiguration.map(value => value: java.lang.Boolean)
      )(_.enforceWorkGroupConfiguration)
      .optionallyWith(
        resultConfigurationUpdates.map(value => value.buildAwsValue())
      )(_.resultConfigurationUpdates)
      .optionallyWith(
        publishCloudWatchMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.publishCloudWatchMetricsEnabled)
      .optionallyWith(
        bytesScannedCutoffPerQuery.map(value =>
          BytesScannedCutoffValue.unwrap(value): java.lang.Long
        )
      )(_.bytesScannedCutoffPerQuery)
      .optionallyWith(
        removeBytesScannedCutoffPerQuery.map(value => value: java.lang.Boolean)
      )(_.removeBytesScannedCutoffPerQuery)
      .optionallyWith(
        requesterPaysEnabled.map(value => value: java.lang.Boolean)
      )(_.requesterPaysEnabled)
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .optionallyWith(
        removeCustomerContentEncryptionConfiguration.map(value =>
          value: java.lang.Boolean
        )
      )(_.removeCustomerContentEncryptionConfiguration)
      .optionallyWith(
        additionalConfiguration.map(value =>
          NameString.unwrap(value): java.lang.String
        )
      )(_.additionalConfiguration)
      .optionallyWith(
        executionRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRole)
      .optionallyWith(
        customerContentEncryptionConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.customerContentEncryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly =
    zio.aws.athena.model.WorkGroupConfigurationUpdates.wrap(buildAwsValue())
}
object WorkGroupConfigurationUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.WorkGroupConfigurationUpdates =
      zio.aws.athena.model.WorkGroupConfigurationUpdates(
        enforceWorkGroupConfiguration.map(value => value),
        resultConfigurationUpdates.map(value => value.asEditable),
        publishCloudWatchMetricsEnabled.map(value => value),
        bytesScannedCutoffPerQuery.map(value => value),
        removeBytesScannedCutoffPerQuery.map(value => value),
        requesterPaysEnabled.map(value => value),
        engineVersion.map(value => value.asEditable),
        removeCustomerContentEncryptionConfiguration.map(value => value),
        additionalConfiguration.map(value => value),
        executionRole.map(value => value),
        customerContentEncryptionConfiguration.map(value => value.asEditable)
      )
    def enforceWorkGroupConfiguration: Optional[BoxedBoolean]
    def resultConfigurationUpdates
        : Optional[zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly]
    def publishCloudWatchMetricsEnabled: Optional[BoxedBoolean]
    def bytesScannedCutoffPerQuery: Optional[BytesScannedCutoffValue]
    def removeBytesScannedCutoffPerQuery: Optional[BoxedBoolean]
    def requesterPaysEnabled: Optional[BoxedBoolean]
    def engineVersion: Optional[zio.aws.athena.model.EngineVersion.ReadOnly]
    def removeCustomerContentEncryptionConfiguration: Optional[BoxedBoolean]
    def additionalConfiguration: Optional[NameString]
    def executionRole: Optional[RoleArn]
    def customerContentEncryptionConfiguration: Optional[
      zio.aws.athena.model.CustomerContentEncryptionConfiguration.ReadOnly
    ]
    def getEnforceWorkGroupConfiguration: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "enforceWorkGroupConfiguration",
        enforceWorkGroupConfiguration
      )
    def getResultConfigurationUpdates: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resultConfigurationUpdates",
      resultConfigurationUpdates
    )
    def getPublishCloudWatchMetricsEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "publishCloudWatchMetricsEnabled",
        publishCloudWatchMetricsEnabled
      )
    def getBytesScannedCutoffPerQuery
        : ZIO[Any, AwsError, BytesScannedCutoffValue] =
      AwsError.unwrapOptionField(
        "bytesScannedCutoffPerQuery",
        bytesScannedCutoffPerQuery
      )
    def getRemoveBytesScannedCutoffPerQuery: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "removeBytesScannedCutoffPerQuery",
        removeBytesScannedCutoffPerQuery
      )
    def getRequesterPaysEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("requesterPaysEnabled", requesterPaysEnabled)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getRemoveCustomerContentEncryptionConfiguration
        : ZIO[Any, AwsError, BoxedBoolean] = AwsError.unwrapOptionField(
      "removeCustomerContentEncryptionConfiguration",
      removeCustomerContentEncryptionConfiguration
    )
    def getAdditionalConfiguration: ZIO[Any, AwsError, NameString] = AwsError
      .unwrapOptionField("additionalConfiguration", additionalConfiguration)
    def getExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getCustomerContentEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.CustomerContentEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customerContentEncryptionConfiguration",
      customerContentEncryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
  ) extends zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly {
    override val enforceWorkGroupConfiguration: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enforceWorkGroupConfiguration())
        .map(value => value: BoxedBoolean)
    override val resultConfigurationUpdates
        : Optional[zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultConfigurationUpdates())
        .map(value =>
          zio.aws.athena.model.ResultConfigurationUpdates.wrap(value)
        )
    override val publishCloudWatchMetricsEnabled: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publishCloudWatchMetricsEnabled())
        .map(value => value: BoxedBoolean)
    override val bytesScannedCutoffPerQuery: Optional[BytesScannedCutoffValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bytesScannedCutoffPerQuery())
        .map(value =>
          zio.aws.athena.model.primitives.BytesScannedCutoffValue(value)
        )
    override val removeBytesScannedCutoffPerQuery: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeBytesScannedCutoffPerQuery())
        .map(value => value: BoxedBoolean)
    override val requesterPaysEnabled: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requesterPaysEnabled())
        .map(value => value: BoxedBoolean)
    override val engineVersion
        : Optional[zio.aws.athena.model.EngineVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersion())
        .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
    override val removeCustomerContentEncryptionConfiguration
        : Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.removeCustomerContentEncryptionConfiguration())
      .map(value => value: BoxedBoolean)
    override val additionalConfiguration: Optional[NameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalConfiguration())
        .map(value => zio.aws.athena.model.primitives.NameString(value))
    override val executionRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.athena.model.primitives.RoleArn(value))
    override val customerContentEncryptionConfiguration: Optional[
      zio.aws.athena.model.CustomerContentEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerContentEncryptionConfiguration())
      .map(value =>
        zio.aws.athena.model.CustomerContentEncryptionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
  ): zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly = new Wrapper(
    impl
  )
}
