package zio.aws.athena.model
import zio.aws.athena.model.primitives.{ErrorMessage, ErrorCode, NamedQueryId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnprocessedNamedQueryId(
    namedQueryId: Optional[NamedQueryId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId = {
    import UnprocessedNamedQueryId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
      .builder()
      .optionallyWith(
        namedQueryId.map(value => NamedQueryId.unwrap(value): java.lang.String)
      )(_.namedQueryId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly =
    zio.aws.athena.model.UnprocessedNamedQueryId.wrap(buildAwsValue())
}
object UnprocessedNamedQueryId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UnprocessedNamedQueryId =
      zio.aws.athena.model.UnprocessedNamedQueryId(
        namedQueryId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def namedQueryId: Optional[NamedQueryId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getNamedQueryId: ZIO[Any, AwsError, NamedQueryId] =
      AwsError.unwrapOptionField("namedQueryId", namedQueryId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
  ) extends zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly {
    override val namedQueryId: Optional[NamedQueryId] = zio.aws.core.internal
      .optionalFromNullable(impl.namedQueryId())
      .map(value => zio.aws.athena.model.primitives.NamedQueryId(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.athena.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.athena.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
  ): zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly = new Wrapper(impl)
}
