package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SessionStatistics(
    dpuExecutionInMillis: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.SessionStatistics = {
    import SessionStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.SessionStatistics
      .builder()
      .optionallyWith(dpuExecutionInMillis.map(value => value: java.lang.Long))(
        _.dpuExecutionInMillis
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.SessionStatistics.ReadOnly =
    zio.aws.athena.model.SessionStatistics.wrap(buildAwsValue())
}
object SessionStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.SessionStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.SessionStatistics =
      zio.aws.athena.model
        .SessionStatistics(dpuExecutionInMillis.map(value => value))
    def dpuExecutionInMillis: Optional[Long]
    def getDpuExecutionInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dpuExecutionInMillis", dpuExecutionInMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.SessionStatistics
  ) extends zio.aws.athena.model.SessionStatistics.ReadOnly {
    override val dpuExecutionInMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dpuExecutionInMillis())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.SessionStatistics
  ): zio.aws.athena.model.SessionStatistics.ReadOnly = new Wrapper(impl)
}
