package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.Age
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ResultReuseByAgeConfiguration(
    enabled: Boolean,
    maxAgeInMinutes: Optional[Age] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultReuseByAgeConfiguration = {
    import ResultReuseByAgeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultReuseByAgeConfiguration
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(maxAgeInMinutes.map(value => Age.unwrap(value): Integer))(
        _.maxAgeInMinutes
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultReuseByAgeConfiguration.ReadOnly =
    zio.aws.athena.model.ResultReuseByAgeConfiguration.wrap(buildAwsValue())
}
object ResultReuseByAgeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultReuseByAgeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultReuseByAgeConfiguration =
      zio.aws.athena.model.ResultReuseByAgeConfiguration(
        enabled,
        maxAgeInMinutes.map(value => value)
      )
    def enabled: Boolean
    def maxAgeInMinutes: Optional[Age]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getMaxAgeInMinutes: ZIO[Any, AwsError, Age] =
      AwsError.unwrapOptionField("maxAgeInMinutes", maxAgeInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultReuseByAgeConfiguration
  ) extends zio.aws.athena.model.ResultReuseByAgeConfiguration.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val maxAgeInMinutes: Optional[Age] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAgeInMinutes())
      .map(value => zio.aws.athena.model.primitives.Age(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultReuseByAgeConfiguration
  ): zio.aws.athena.model.ResultReuseByAgeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
