package zio.aws.athena.model
import zio.aws.athena.model.primitives.CodeBlock
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCalculationExecutionCodeResponse(
    codeBlock: Optional[CodeBlock] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse = {
    import GetCalculationExecutionCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse
      .builder()
      .optionallyWith(
        codeBlock.map(value => CodeBlock.unwrap(value): java.lang.String)
      )(_.codeBlock)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly =
    zio.aws.athena.model.GetCalculationExecutionCodeResponse
      .wrap(buildAwsValue())
}
object GetCalculationExecutionCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCalculationExecutionCodeResponse =
      zio.aws.athena.model
        .GetCalculationExecutionCodeResponse(codeBlock.map(value => value))
    def codeBlock: Optional[CodeBlock]
    def getCodeBlock: ZIO[Any, AwsError, CodeBlock] =
      AwsError.unwrapOptionField("codeBlock", codeBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse
  ) extends zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly {
    override val codeBlock: Optional[CodeBlock] = zio.aws.core.internal
      .optionalFromNullable(impl.codeBlock())
      .map(value => zio.aws.athena.model.primitives.CodeBlock(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse
  ): zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly =
    new Wrapper(impl)
}
