package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutorState {
  def unwrap: software.amazon.awssdk.services.athena.model.ExecutorState
}
object ExecutorState {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.ExecutorState
  ): zio.aws.athena.model.ExecutorState = value match {
    case software.amazon.awssdk.services.athena.model.ExecutorState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.ExecutorState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.athena.model.ExecutorState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.athena.model.ExecutorState.REGISTERED =>
      val r = REGISTERED
      r
    case software.amazon.awssdk.services.athena.model.ExecutorState.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.athena.model.ExecutorState.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.athena.model.ExecutorState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.ExecutorState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorState =
      software.amazon.awssdk.services.athena.model.ExecutorState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.athena.model.ExecutorState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorState =
      software.amazon.awssdk.services.athena.model.ExecutorState.CREATING
  }
  case object CREATED extends zio.aws.athena.model.ExecutorState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorState =
      software.amazon.awssdk.services.athena.model.ExecutorState.CREATED
  }
  case object REGISTERED extends zio.aws.athena.model.ExecutorState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorState =
      software.amazon.awssdk.services.athena.model.ExecutorState.REGISTERED
  }
  case object TERMINATING extends zio.aws.athena.model.ExecutorState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorState =
      software.amazon.awssdk.services.athena.model.ExecutorState.TERMINATING
  }
  case object TERMINATED extends zio.aws.athena.model.ExecutorState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorState =
      software.amazon.awssdk.services.athena.model.ExecutorState.TERMINATED
  }
  case object FAILED extends zio.aws.athena.model.ExecutorState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorState =
      software.amazon.awssdk.services.athena.model.ExecutorState.FAILED
  }
}
