package zio.aws.athena.model
import zio.aws.athena.model.primitives.{CommentString, TypeString, NameString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Column(
    name: NameString,
    `type`: Optional[TypeString] = Optional.Absent,
    comment: Optional[CommentString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.athena.model.Column = {
    import Column.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.Column
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        `type`.map(value => TypeString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        comment.map(value => CommentString.unwrap(value): java.lang.String)
      )(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.Column.ReadOnly =
    zio.aws.athena.model.Column.wrap(buildAwsValue())
}
object Column {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.Column] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.Column = zio.aws.athena.model
      .Column(name, `type`.map(value => value), comment.map(value => value))
    def name: NameString
    def `type`: Optional[TypeString]
    def comment: Optional[CommentString]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getType: ZIO[Any, AwsError, TypeString] =
      AwsError.unwrapOptionField("type", `type`)
    def getComment: ZIO[Any, AwsError, CommentString] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.Column
  ) extends zio.aws.athena.model.Column.ReadOnly {
    override val name: NameString =
      zio.aws.athena.model.primitives.NameString(impl.name())
    override val `type`: Optional[TypeString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.athena.model.primitives.TypeString(value))
    override val comment: Optional[CommentString] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.athena.model.primitives.CommentString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.Column
  ): zio.aws.athena.model.Column.ReadOnly = new Wrapper(impl)
}
