package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  DescriptionString,
  CalculationExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CalculationSummary(
    calculationExecutionId: Optional[CalculationExecutionId] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    status: Optional[zio.aws.athena.model.CalculationStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CalculationSummary = {
    import CalculationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CalculationSummary
      .builder()
      .optionallyWith(
        calculationExecutionId.map(value =>
          CalculationExecutionId.unwrap(value): java.lang.String
        )
      )(_.calculationExecutionId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CalculationSummary.ReadOnly =
    zio.aws.athena.model.CalculationSummary.wrap(buildAwsValue())
}
object CalculationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CalculationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CalculationSummary =
      zio.aws.athena.model.CalculationSummary(
        calculationExecutionId.map(value => value),
        description.map(value => value),
        status.map(value => value.asEditable)
      )
    def calculationExecutionId: Optional[CalculationExecutionId]
    def description: Optional[DescriptionString]
    def status: Optional[zio.aws.athena.model.CalculationStatus.ReadOnly]
    def getCalculationExecutionId: ZIO[Any, AwsError, CalculationExecutionId] =
      AwsError.unwrapOptionField(
        "calculationExecutionId",
        calculationExecutionId
      )
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CalculationSummary
  ) extends zio.aws.athena.model.CalculationSummary.ReadOnly {
    override val calculationExecutionId: Optional[CalculationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculationExecutionId())
        .map(value =>
          zio.aws.athena.model.primitives.CalculationExecutionId(value)
        )
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val status
        : Optional[zio.aws.athena.model.CalculationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.athena.model.CalculationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CalculationSummary
  ): zio.aws.athena.model.CalculationSummary.ReadOnly = new Wrapper(impl)
}
