package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetQueryExecutionResponse(
    queryExecutions: Optional[Iterable[zio.aws.athena.model.QueryExecution]] =
      Optional.Absent,
    unprocessedQueryExecutionIds: Optional[
      Iterable[zio.aws.athena.model.UnprocessedQueryExecutionId]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse = {
    import BatchGetQueryExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse
      .builder()
      .optionallyWith(
        queryExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryExecutions)
      .optionallyWith(
        unprocessedQueryExecutionIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedQueryExecutionIds)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly =
    zio.aws.athena.model.BatchGetQueryExecutionResponse.wrap(buildAwsValue())
}
object BatchGetQueryExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.BatchGetQueryExecutionResponse =
      zio.aws.athena.model.BatchGetQueryExecutionResponse(
        queryExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedQueryExecutionIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def queryExecutions
        : Optional[List[zio.aws.athena.model.QueryExecution.ReadOnly]]
    def unprocessedQueryExecutionIds: Optional[
      List[zio.aws.athena.model.UnprocessedQueryExecutionId.ReadOnly]
    ]
    def getQueryExecutions: ZIO[Any, AwsError, List[
      zio.aws.athena.model.QueryExecution.ReadOnly
    ]] = AwsError.unwrapOptionField("queryExecutions", queryExecutions)
    def getUnprocessedQueryExecutionIds: ZIO[Any, AwsError, List[
      zio.aws.athena.model.UnprocessedQueryExecutionId.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedQueryExecutionIds",
      unprocessedQueryExecutionIds
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse
  ) extends zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly {
    override val queryExecutions
        : Optional[List[zio.aws.athena.model.QueryExecution.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.QueryExecution.wrap(item)
          }.toList
        )
    override val unprocessedQueryExecutionIds: Optional[
      List[zio.aws.athena.model.UnprocessedQueryExecutionId.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedQueryExecutionIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.UnprocessedQueryExecutionId.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse
  ): zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
