package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait NotebookType {
  def unwrap: software.amazon.awssdk.services.athena.model.NotebookType
}
object NotebookType {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.NotebookType
  ): zio.aws.athena.model.NotebookType = value match {
    case software.amazon.awssdk.services.athena.model.NotebookType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.NotebookType.IPYNB =>
      val r = IPYNB
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.NotebookType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.NotebookType =
      software.amazon.awssdk.services.athena.model.NotebookType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPYNB extends zio.aws.athena.model.NotebookType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.NotebookType =
      software.amazon.awssdk.services.athena.model.NotebookType.IPYNB
  }
}
