package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{MaxWorkGroupsCount, Token}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkGroupsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxWorkGroupsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest = {
    import ListWorkGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxWorkGroupsCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListWorkGroupsRequest.ReadOnly =
    zio.aws.athena.model.ListWorkGroupsRequest.wrap(buildAwsValue())
}
object ListWorkGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListWorkGroupsRequest =
      zio.aws.athena.model.ListWorkGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxWorkGroupsCount]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxWorkGroupsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
  ) extends zio.aws.athena.model.ListWorkGroupsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxWorkGroupsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.athena.model.primitives.MaxWorkGroupsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
  ): zio.aws.athena.model.ListWorkGroupsRequest.ReadOnly = new Wrapper(impl)
}
