package zio.aws.athena.model
import zio.aws.athena.model.primitives.NotebookId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetNotebookMetadataRequest(notebookId: NotebookId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest = {
    import GetNotebookMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest
      .builder()
      .notebookId(NotebookId.unwrap(notebookId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetNotebookMetadataRequest.ReadOnly =
    zio.aws.athena.model.GetNotebookMetadataRequest.wrap(buildAwsValue())
}
object GetNotebookMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetNotebookMetadataRequest =
      zio.aws.athena.model.GetNotebookMetadataRequest(notebookId)
    def notebookId: NotebookId
    def getNotebookId: ZIO[Any, Nothing, NotebookId] = ZIO.succeed(notebookId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest
  ) extends zio.aws.athena.model.GetNotebookMetadataRequest.ReadOnly {
    override val notebookId: NotebookId =
      zio.aws.athena.model.primitives.NotebookId(impl.notebookId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest
  ): zio.aws.athena.model.GetNotebookMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
