package zio.aws.athena.model
import zio.aws.athena.model.primitives.Payload
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportNotebookResponse(
    notebookMetadata: Optional[zio.aws.athena.model.NotebookMetadata] =
      Optional.Absent,
    payload: Optional[Payload] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ExportNotebookResponse = {
    import ExportNotebookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ExportNotebookResponse
      .builder()
      .optionallyWith(notebookMetadata.map(value => value.buildAwsValue()))(
        _.notebookMetadata
      )
      .optionallyWith(
        payload.map(value => Payload.unwrap(value): java.lang.String)
      )(_.payload)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ExportNotebookResponse.ReadOnly =
    zio.aws.athena.model.ExportNotebookResponse.wrap(buildAwsValue())
}
object ExportNotebookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ExportNotebookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ExportNotebookResponse =
      zio.aws.athena.model.ExportNotebookResponse(
        notebookMetadata.map(value => value.asEditable),
        payload.map(value => value)
      )
    def notebookMetadata
        : Optional[zio.aws.athena.model.NotebookMetadata.ReadOnly]
    def payload: Optional[Payload]
    def getNotebookMetadata
        : ZIO[Any, AwsError, zio.aws.athena.model.NotebookMetadata.ReadOnly] =
      AwsError.unwrapOptionField("notebookMetadata", notebookMetadata)
    def getPayload: ZIO[Any, AwsError, Payload] =
      AwsError.unwrapOptionField("payload", payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ExportNotebookResponse
  ) extends zio.aws.athena.model.ExportNotebookResponse.ReadOnly {
    override val notebookMetadata
        : Optional[zio.aws.athena.model.NotebookMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookMetadata())
        .map(value => zio.aws.athena.model.NotebookMetadata.wrap(value))
    override val payload: Optional[Payload] = zio.aws.core.internal
      .optionalFromNullable(impl.payload())
      .map(value => zio.aws.athena.model.primitives.Payload(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ExportNotebookResponse
  ): zio.aws.athena.model.ExportNotebookResponse.ReadOnly = new Wrapper(impl)
}
