package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AclConfiguration(
    s3AclOption: zio.aws.athena.model.S3AclOption
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.AclConfiguration = {
    import AclConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.AclConfiguration
      .builder()
      .s3AclOption(s3AclOption.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.AclConfiguration.ReadOnly =
    zio.aws.athena.model.AclConfiguration.wrap(buildAwsValue())
}
object AclConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.AclConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.AclConfiguration =
      zio.aws.athena.model.AclConfiguration(s3AclOption)
    def s3AclOption: zio.aws.athena.model.S3AclOption
    def getS3AclOption: ZIO[Any, Nothing, zio.aws.athena.model.S3AclOption] =
      ZIO.succeed(s3AclOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.AclConfiguration
  ) extends zio.aws.athena.model.AclConfiguration.ReadOnly {
    override val s3AclOption: zio.aws.athena.model.S3AclOption =
      zio.aws.athena.model.S3AclOption.wrap(impl.s3AclOption())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.AclConfiguration
  ): zio.aws.athena.model.AclConfiguration.ReadOnly = new Wrapper(impl)
}
