package zio.aws.athena.model
import zio.aws.athena.model.primitives.{ErrorMessage, ErrorCode, StatementName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnprocessedPreparedStatementName(
    statementName: Optional[StatementName] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName = {
    import UnprocessedPreparedStatementName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName
      .builder()
      .optionallyWith(
        statementName.map(value =>
          StatementName.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.UnprocessedPreparedStatementName.ReadOnly =
    zio.aws.athena.model.UnprocessedPreparedStatementName.wrap(buildAwsValue())
}
object UnprocessedPreparedStatementName {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UnprocessedPreparedStatementName =
      zio.aws.athena.model.UnprocessedPreparedStatementName(
        statementName.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def statementName: Optional[StatementName]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getStatementName: ZIO[Any, AwsError, StatementName] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName
  ) extends zio.aws.athena.model.UnprocessedPreparedStatementName.ReadOnly {
    override val statementName: Optional[StatementName] = zio.aws.core.internal
      .optionalFromNullable(impl.statementName())
      .map(value => zio.aws.athena.model.primitives.StatementName(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.athena.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.athena.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName
  ): zio.aws.athena.model.UnprocessedPreparedStatementName.ReadOnly =
    new Wrapper(impl)
}
