package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  NameString,
  DescriptionString,
  SessionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SessionSummary(
    sessionId: Optional[SessionId] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    engineVersion: Optional[zio.aws.athena.model.EngineVersion] =
      Optional.Absent,
    notebookVersion: Optional[NameString] = Optional.Absent,
    status: Optional[zio.aws.athena.model.SessionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.SessionSummary = {
    import SessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.SessionSummary
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .optionallyWith(
        notebookVersion.map(value => NameString.unwrap(value): java.lang.String)
      )(_.notebookVersion)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.SessionSummary.ReadOnly =
    zio.aws.athena.model.SessionSummary.wrap(buildAwsValue())
}
object SessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.SessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.SessionSummary =
      zio.aws.athena.model.SessionSummary(
        sessionId.map(value => value),
        description.map(value => value),
        engineVersion.map(value => value.asEditable),
        notebookVersion.map(value => value),
        status.map(value => value.asEditable)
      )
    def sessionId: Optional[SessionId]
    def description: Optional[DescriptionString]
    def engineVersion: Optional[zio.aws.athena.model.EngineVersion.ReadOnly]
    def notebookVersion: Optional[NameString]
    def status: Optional[zio.aws.athena.model.SessionStatus.ReadOnly]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getNotebookVersion: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("notebookVersion", notebookVersion)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.athena.model.SessionStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.SessionSummary
  ) extends zio.aws.athena.model.SessionSummary.ReadOnly {
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.athena.model.primitives.SessionId(value))
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val engineVersion
        : Optional[zio.aws.athena.model.EngineVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersion())
        .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
    override val notebookVersion: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookVersion())
      .map(value => zio.aws.athena.model.primitives.NameString(value))
    override val status: Optional[zio.aws.athena.model.SessionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.athena.model.SessionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.SessionSummary
  ): zio.aws.athena.model.SessionSummary.ReadOnly = new Wrapper(impl)
}
