package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResultReuseInformation(reusedPreviousResult: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultReuseInformation = {
    import ResultReuseInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultReuseInformation
      .builder()
      .reusedPreviousResult(reusedPreviousResult: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultReuseInformation.ReadOnly =
    zio.aws.athena.model.ResultReuseInformation.wrap(buildAwsValue())
}
object ResultReuseInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultReuseInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultReuseInformation =
      zio.aws.athena.model.ResultReuseInformation(reusedPreviousResult)
    def reusedPreviousResult: Boolean
    def getReusedPreviousResult: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(reusedPreviousResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultReuseInformation
  ) extends zio.aws.athena.model.ResultReuseInformation.ReadOnly {
    override val reusedPreviousResult: Boolean =
      impl.reusedPreviousResult(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultReuseInformation
  ): zio.aws.athena.model.ResultReuseInformation.ReadOnly = new Wrapper(impl)
}
