package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryRuntimeStatisticsTimeline(
    queryQueueTimeInMillis: Optional[Long] = Optional.Absent,
    queryPlanningTimeInMillis: Optional[Long] = Optional.Absent,
    engineExecutionTimeInMillis: Optional[Long] = Optional.Absent,
    serviceProcessingTimeInMillis: Optional[Long] = Optional.Absent,
    totalExecutionTimeInMillis: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsTimeline = {
    import QueryRuntimeStatisticsTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsTimeline
      .builder()
      .optionallyWith(
        queryQueueTimeInMillis.map(value => value: java.lang.Long)
      )(_.queryQueueTimeInMillis)
      .optionallyWith(
        queryPlanningTimeInMillis.map(value => value: java.lang.Long)
      )(_.queryPlanningTimeInMillis)
      .optionallyWith(
        engineExecutionTimeInMillis.map(value => value: java.lang.Long)
      )(_.engineExecutionTimeInMillis)
      .optionallyWith(
        serviceProcessingTimeInMillis.map(value => value: java.lang.Long)
      )(_.serviceProcessingTimeInMillis)
      .optionallyWith(
        totalExecutionTimeInMillis.map(value => value: java.lang.Long)
      )(_.totalExecutionTimeInMillis)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryRuntimeStatisticsTimeline.ReadOnly =
    zio.aws.athena.model.QueryRuntimeStatisticsTimeline.wrap(buildAwsValue())
}
object QueryRuntimeStatisticsTimeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsTimeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryRuntimeStatisticsTimeline =
      zio.aws.athena.model.QueryRuntimeStatisticsTimeline(
        queryQueueTimeInMillis.map(value => value),
        queryPlanningTimeInMillis.map(value => value),
        engineExecutionTimeInMillis.map(value => value),
        serviceProcessingTimeInMillis.map(value => value),
        totalExecutionTimeInMillis.map(value => value)
      )
    def queryQueueTimeInMillis: Optional[Long]
    def queryPlanningTimeInMillis: Optional[Long]
    def engineExecutionTimeInMillis: Optional[Long]
    def serviceProcessingTimeInMillis: Optional[Long]
    def totalExecutionTimeInMillis: Optional[Long]
    def getQueryQueueTimeInMillis: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("queryQueueTimeInMillis", queryQueueTimeInMillis)
    def getQueryPlanningTimeInMillis: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("queryPlanningTimeInMillis", queryPlanningTimeInMillis)
    def getEngineExecutionTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "engineExecutionTimeInMillis",
        engineExecutionTimeInMillis
      )
    def getServiceProcessingTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "serviceProcessingTimeInMillis",
        serviceProcessingTimeInMillis
      )
    def getTotalExecutionTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "totalExecutionTimeInMillis",
        totalExecutionTimeInMillis
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsTimeline
  ) extends zio.aws.athena.model.QueryRuntimeStatisticsTimeline.ReadOnly {
    override val queryQueueTimeInMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.queryQueueTimeInMillis())
      .map(value => value: Long)
    override val queryPlanningTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryPlanningTimeInMillis())
        .map(value => value: Long)
    override val engineExecutionTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineExecutionTimeInMillis())
        .map(value => value: Long)
    override val serviceProcessingTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceProcessingTimeInMillis())
        .map(value => value: Long)
    override val totalExecutionTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalExecutionTimeInMillis())
        .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsTimeline
  ): zio.aws.athena.model.QueryRuntimeStatisticsTimeline.ReadOnly = new Wrapper(
    impl
  )
}
