package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{Token, MaxSessionsCount, NotebookId}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListNotebookSessionsRequest(
    notebookId: NotebookId,
    maxResults: Optional[MaxSessionsCount] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest = {
    import ListNotebookSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest
      .builder()
      .notebookId(NotebookId.unwrap(notebookId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxSessionsCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNotebookSessionsRequest.ReadOnly =
    zio.aws.athena.model.ListNotebookSessionsRequest.wrap(buildAwsValue())
}
object ListNotebookSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNotebookSessionsRequest =
      zio.aws.athena.model.ListNotebookSessionsRequest(
        notebookId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def notebookId: NotebookId
    def maxResults: Optional[MaxSessionsCount]
    def nextToken: Optional[Token]
    def getNotebookId: ZIO[Any, Nothing, NotebookId] = ZIO.succeed(notebookId)
    def getMaxResults: ZIO[Any, AwsError, MaxSessionsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest
  ) extends zio.aws.athena.model.ListNotebookSessionsRequest.ReadOnly {
    override val notebookId: NotebookId =
      zio.aws.athena.model.primitives.NotebookId(impl.notebookId())
    override val maxResults: Optional[MaxSessionsCount] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxSessionsCount(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest
  ): zio.aws.athena.model.ListNotebookSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
