package zio.aws.athena.model
import zio.aws.athena.model.primitives.{Token, NamedQueryId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNamedQueriesResponse(
    namedQueryIds: Optional[Iterable[NamedQueryId]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse = {
    import ListNamedQueriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
      .builder()
      .optionallyWith(
        namedQueryIds.map(value =>
          value.map { item =>
            NamedQueryId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.namedQueryIds)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly =
    zio.aws.athena.model.ListNamedQueriesResponse.wrap(buildAwsValue())
}
object ListNamedQueriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNamedQueriesResponse =
      zio.aws.athena.model.ListNamedQueriesResponse(
        namedQueryIds.map(value => value),
        nextToken.map(value => value)
      )
    def namedQueryIds: Optional[List[NamedQueryId]]
    def nextToken: Optional[Token]
    def getNamedQueryIds: ZIO[Any, AwsError, List[NamedQueryId]] =
      AwsError.unwrapOptionField("namedQueryIds", namedQueryIds)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
  ) extends zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly {
    override val namedQueryIds: Optional[List[NamedQueryId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namedQueryIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.primitives.NamedQueryId(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
  ): zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly = new Wrapper(impl)
}
