package zio.aws.athena.model
import zio.aws.athena.model.primitives.NamedQueryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetNamedQueryRequest(namedQueryId: NamedQueryId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetNamedQueryRequest = {
    import GetNamedQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetNamedQueryRequest
      .builder()
      .namedQueryId(NamedQueryId.unwrap(namedQueryId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetNamedQueryRequest.ReadOnly =
    zio.aws.athena.model.GetNamedQueryRequest.wrap(buildAwsValue())
}
object GetNamedQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetNamedQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetNamedQueryRequest =
      zio.aws.athena.model.GetNamedQueryRequest(namedQueryId)
    def namedQueryId: NamedQueryId
    def getNamedQueryId: ZIO[Any, Nothing, NamedQueryId] =
      ZIO.succeed(namedQueryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetNamedQueryRequest
  ) extends zio.aws.athena.model.GetNamedQueryRequest.ReadOnly {
    override val namedQueryId: NamedQueryId =
      zio.aws.athena.model.primitives.NamedQueryId(impl.namedQueryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetNamedQueryRequest
  ): zio.aws.athena.model.GetNamedQueryRequest.ReadOnly = new Wrapper(impl)
}
