package zio.aws.athena.model
import zio.aws.athena.model.primitives.CalculationExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCalculationExecutionRequest(
    calculationExecutionId: CalculationExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest = {
    import GetCalculationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest
      .builder()
      .calculationExecutionId(
        CalculationExecutionId.unwrap(calculationExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetCalculationExecutionRequest.ReadOnly =
    zio.aws.athena.model.GetCalculationExecutionRequest.wrap(buildAwsValue())
}
object GetCalculationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCalculationExecutionRequest =
      zio.aws.athena.model
        .GetCalculationExecutionRequest(calculationExecutionId)
    def calculationExecutionId: CalculationExecutionId
    def getCalculationExecutionId: ZIO[Any, Nothing, CalculationExecutionId] =
      ZIO.succeed(calculationExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest
  ) extends zio.aws.athena.model.GetCalculationExecutionRequest.ReadOnly {
    override val calculationExecutionId: CalculationExecutionId =
      zio.aws.athena.model.primitives
        .CalculationExecutionId(impl.calculationExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest
  ): zio.aws.athena.model.GetCalculationExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
