package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  MaxConcurrentDpus,
  DefaultExecutorDpuSize,
  KeyString,
  ParametersMapValue,
  CoordinatorDpuSize
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EngineConfiguration(
    coordinatorDpuSize: Optional[CoordinatorDpuSize] = Optional.Absent,
    maxConcurrentDpus: MaxConcurrentDpus,
    defaultExecutorDpuSize: Optional[DefaultExecutorDpuSize] = Optional.Absent,
    additionalConfigs: Optional[Map[KeyString, ParametersMapValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.EngineConfiguration = {
    import EngineConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.EngineConfiguration
      .builder()
      .optionallyWith(
        coordinatorDpuSize.map(value =>
          CoordinatorDpuSize.unwrap(value): Integer
        )
      )(_.coordinatorDpuSize)
      .maxConcurrentDpus(MaxConcurrentDpus.unwrap(maxConcurrentDpus): Integer)
      .optionallyWith(
        defaultExecutorDpuSize.map(value =>
          DefaultExecutorDpuSize.unwrap(value): Integer
        )
      )(_.defaultExecutorDpuSize)
      .optionallyWith(
        additionalConfigs.map(value =>
          value
            .map({ case (key, value) =>
              (KeyString.unwrap(key): java.lang.String) -> (ParametersMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.additionalConfigs)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.EngineConfiguration.ReadOnly =
    zio.aws.athena.model.EngineConfiguration.wrap(buildAwsValue())
}
object EngineConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.EngineConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.EngineConfiguration =
      zio.aws.athena.model.EngineConfiguration(
        coordinatorDpuSize.map(value => value),
        maxConcurrentDpus,
        defaultExecutorDpuSize.map(value => value),
        additionalConfigs.map(value => value)
      )
    def coordinatorDpuSize: Optional[CoordinatorDpuSize]
    def maxConcurrentDpus: MaxConcurrentDpus
    def defaultExecutorDpuSize: Optional[DefaultExecutorDpuSize]
    def additionalConfigs: Optional[Map[KeyString, ParametersMapValue]]
    def getCoordinatorDpuSize: ZIO[Any, AwsError, CoordinatorDpuSize] =
      AwsError.unwrapOptionField("coordinatorDpuSize", coordinatorDpuSize)
    def getMaxConcurrentDpus: ZIO[Any, Nothing, MaxConcurrentDpus] =
      ZIO.succeed(maxConcurrentDpus)
    def getDefaultExecutorDpuSize: ZIO[Any, AwsError, DefaultExecutorDpuSize] =
      AwsError.unwrapOptionField(
        "defaultExecutorDpuSize",
        defaultExecutorDpuSize
      )
    def getAdditionalConfigs
        : ZIO[Any, AwsError, Map[KeyString, ParametersMapValue]] =
      AwsError.unwrapOptionField("additionalConfigs", additionalConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.EngineConfiguration
  ) extends zio.aws.athena.model.EngineConfiguration.ReadOnly {
    override val coordinatorDpuSize: Optional[CoordinatorDpuSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coordinatorDpuSize())
        .map(value => zio.aws.athena.model.primitives.CoordinatorDpuSize(value))
    override val maxConcurrentDpus: MaxConcurrentDpus =
      zio.aws.athena.model.primitives
        .MaxConcurrentDpus(impl.maxConcurrentDpus())
    override val defaultExecutorDpuSize: Optional[DefaultExecutorDpuSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultExecutorDpuSize())
        .map(value =>
          zio.aws.athena.model.primitives.DefaultExecutorDpuSize(value)
        )
    override val additionalConfigs
        : Optional[Map[KeyString, ParametersMapValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalConfigs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.athena.model.primitives.KeyString(
              key
            ) -> zio.aws.athena.model.primitives.ParametersMapValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.EngineConfiguration
  ): zio.aws.athena.model.EngineConfiguration.ReadOnly = new Wrapper(impl)
}
