package zio.aws.athena.model
import zio.aws.athena.model.primitives.KmsKey
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomerContentEncryptionConfiguration(kmsKey: KmsKey) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CustomerContentEncryptionConfiguration = {
    import CustomerContentEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CustomerContentEncryptionConfiguration
      .builder()
      .kmsKey(KmsKey.unwrap(kmsKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.CustomerContentEncryptionConfiguration.ReadOnly =
    zio.aws.athena.model.CustomerContentEncryptionConfiguration
      .wrap(buildAwsValue())
}
object CustomerContentEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CustomerContentEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.athena.model.CustomerContentEncryptionConfiguration =
      zio.aws.athena.model.CustomerContentEncryptionConfiguration(kmsKey)
    def kmsKey: KmsKey
    def getKmsKey: ZIO[Any, Nothing, KmsKey] = ZIO.succeed(kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CustomerContentEncryptionConfiguration
  ) extends zio.aws.athena.model.CustomerContentEncryptionConfiguration.ReadOnly {
    override val kmsKey: KmsKey =
      zio.aws.athena.model.primitives.KmsKey(impl.kmsKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CustomerContentEncryptionConfiguration
  ): zio.aws.athena.model.CustomerContentEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
