package zio.aws.athena.model
import zio.aws.athena.model.primitives.AuthToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreatePresignedNotebookUrlResponse(
    notebookUrl: String,
    authToken: AuthToken,
    authTokenExpirationTime: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse = {
    import CreatePresignedNotebookUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse
      .builder()
      .notebookUrl(notebookUrl: java.lang.String)
      .authToken(AuthToken.unwrap(authToken): java.lang.String)
      .authTokenExpirationTime(authTokenExpirationTime: java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly =
    zio.aws.athena.model.CreatePresignedNotebookUrlResponse
      .wrap(buildAwsValue())
}
object CreatePresignedNotebookUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreatePresignedNotebookUrlResponse =
      zio.aws.athena.model.CreatePresignedNotebookUrlResponse(
        notebookUrl,
        authToken,
        authTokenExpirationTime
      )
    def notebookUrl: String
    def authToken: AuthToken
    def authTokenExpirationTime: Long
    def getNotebookUrl: ZIO[Any, Nothing, String] = ZIO.succeed(notebookUrl)
    def getAuthToken: ZIO[Any, Nothing, AuthToken] = ZIO.succeed(authToken)
    def getAuthTokenExpirationTime: ZIO[Any, Nothing, Long] =
      ZIO.succeed(authTokenExpirationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse
  ) extends zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly {
    override val notebookUrl: String = impl.notebookUrl(): String
    override val authToken: AuthToken =
      zio.aws.athena.model.primitives.AuthToken(impl.authToken())
    override val authTokenExpirationTime: Long =
      impl.authTokenExpirationTime(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse
  ): zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly =
    new Wrapper(impl)
}
