package zio.aws.athena.model
import zio.aws.athena.model.primitives.NotebookId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNotebookResponse(
    notebookId: Optional[NotebookId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreateNotebookResponse = {
    import CreateNotebookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreateNotebookResponse
      .builder()
      .optionallyWith(
        notebookId.map(value => NotebookId.unwrap(value): java.lang.String)
      )(_.notebookId)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CreateNotebookResponse.ReadOnly =
    zio.aws.athena.model.CreateNotebookResponse.wrap(buildAwsValue())
}
object CreateNotebookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreateNotebookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreateNotebookResponse =
      zio.aws.athena.model
        .CreateNotebookResponse(notebookId.map(value => value))
    def notebookId: Optional[NotebookId]
    def getNotebookId: ZIO[Any, AwsError, NotebookId] =
      AwsError.unwrapOptionField("notebookId", notebookId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreateNotebookResponse
  ) extends zio.aws.athena.model.CreateNotebookResponse.ReadOnly {
    override val notebookId: Optional[NotebookId] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookId())
      .map(value => zio.aws.athena.model.primitives.NotebookId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreateNotebookResponse
  ): zio.aws.athena.model.CreateNotebookResponse.ReadOnly = new Wrapper(impl)
}
