package zio.aws.athena.model
import zio.aws.athena.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ColumnInfo(
    catalogName: Optional[String] = Optional.Absent,
    schemaName: Optional[String] = Optional.Absent,
    tableName: Optional[String] = Optional.Absent,
    name: String,
    label: Optional[String] = Optional.Absent,
    `type`: String,
    precision: Optional[Integer] = Optional.Absent,
    scale: Optional[Integer] = Optional.Absent,
    nullable: Optional[zio.aws.athena.model.ColumnNullable] = Optional.Absent,
    caseSensitive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ColumnInfo = {
    import ColumnInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ColumnInfo
      .builder()
      .optionallyWith(catalogName.map(value => value: java.lang.String))(
        _.catalogName
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .name(name: java.lang.String)
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .`type`(`type`: java.lang.String)
      .optionallyWith(precision.map(value => value: java.lang.Integer))(
        _.precision
      )
      .optionallyWith(scale.map(value => value: java.lang.Integer))(_.scale)
      .optionallyWith(nullable.map(value => value.unwrap))(_.nullable)
      .optionallyWith(caseSensitive.map(value => value: java.lang.Boolean))(
        _.caseSensitive
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ColumnInfo.ReadOnly =
    zio.aws.athena.model.ColumnInfo.wrap(buildAwsValue())
}
object ColumnInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.ColumnInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ColumnInfo =
      zio.aws.athena.model.ColumnInfo(
        catalogName.map(value => value),
        schemaName.map(value => value),
        tableName.map(value => value),
        name,
        label.map(value => value),
        `type`,
        precision.map(value => value),
        scale.map(value => value),
        nullable.map(value => value),
        caseSensitive.map(value => value)
      )
    def catalogName: Optional[String]
    def schemaName: Optional[String]
    def tableName: Optional[String]
    def name: String
    def label: Optional[String]
    def `type`: String
    def precision: Optional[Integer]
    def scale: Optional[Integer]
    def nullable: Optional[zio.aws.athena.model.ColumnNullable]
    def caseSensitive: Optional[Boolean]
    def getCatalogName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("catalogName", catalogName)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getPrecision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("precision", precision)
    def getScale: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scale", scale)
    def getNullable: ZIO[Any, AwsError, zio.aws.athena.model.ColumnNullable] =
      AwsError.unwrapOptionField("nullable", nullable)
    def getCaseSensitive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("caseSensitive", caseSensitive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ColumnInfo
  ) extends zio.aws.athena.model.ColumnInfo.ReadOnly {
    override val catalogName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogName())
      .map(value => value: String)
    override val schemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: String)
    override val tableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val `type`: String = impl.`type`(): String
    override val precision: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.precision())
      .map(value => value: Integer)
    override val scale: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scale())
      .map(value => value: Integer)
    override val nullable: Optional[zio.aws.athena.model.ColumnNullable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nullable())
        .map(value => zio.aws.athena.model.ColumnNullable.wrap(value))
    override val caseSensitive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.caseSensitive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ColumnInfo
  ): zio.aws.athena.model.ColumnInfo.ReadOnly = new Wrapper(impl)
}
