package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait CalculationExecutionState {
  def unwrap
      : software.amazon.awssdk.services.athena.model.CalculationExecutionState
}
object CalculationExecutionState {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.CalculationExecutionState
  ): zio.aws.athena.model.CalculationExecutionState = value match {
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.CANCELING =>
      val r = CANCELING
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.athena.model.CalculationExecutionState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.CREATING
  }
  case object CREATED extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.CREATED
  }
  case object QUEUED extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.QUEUED
  }
  case object RUNNING extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.RUNNING
  }
  case object CANCELING extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.CANCELING
  }
  case object CANCELED extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.CANCELED
  }
  case object COMPLETED extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.COMPLETED
  }
  case object FAILED extends zio.aws.athena.model.CalculationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CalculationExecutionState =
      software.amazon.awssdk.services.athena.model.CalculationExecutionState.FAILED
  }
}
