package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ParametersMapValue,
  KeyString,
  DescriptionString,
  CatalogNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDataCatalogRequest(
    name: CatalogNameString,
    `type`: zio.aws.athena.model.DataCatalogType,
    description: Optional[DescriptionString] = Optional.Absent,
    parameters: Optional[Map[KeyString, ParametersMapValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest = {
    import UpdateDataCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest
      .builder()
      .name(CatalogNameString.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (KeyString.unwrap(key): java.lang.String) -> (ParametersMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UpdateDataCatalogRequest.ReadOnly =
    zio.aws.athena.model.UpdateDataCatalogRequest.wrap(buildAwsValue())
}
object UpdateDataCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UpdateDataCatalogRequest =
      zio.aws.athena.model.UpdateDataCatalogRequest(
        name,
        `type`,
        description.map(value => value),
        parameters.map(value => value)
      )
    def name: CatalogNameString
    def `type`: zio.aws.athena.model.DataCatalogType
    def description: Optional[DescriptionString]
    def parameters: Optional[Map[KeyString, ParametersMapValue]]
    def getName: ZIO[Any, Nothing, CatalogNameString] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.athena.model.DataCatalogType] =
      ZIO.succeed(`type`)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, Map[KeyString, ParametersMapValue]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest
  ) extends zio.aws.athena.model.UpdateDataCatalogRequest.ReadOnly {
    override val name: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.name())
    override val `type`: zio.aws.athena.model.DataCatalogType =
      zio.aws.athena.model.DataCatalogType.wrap(impl.`type`())
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val parameters: Optional[Map[KeyString, ParametersMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.athena.model.primitives.KeyString(
                key
              ) -> zio.aws.athena.model.primitives.ParametersMapValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest
  ): zio.aws.athena.model.UpdateDataCatalogRequest.ReadOnly = new Wrapper(impl)
}
