package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  SessionIdleTimeoutInMinutes,
  WorkGroupName,
  IdempotencyToken,
  NameString,
  DescriptionString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartSessionRequest(
    description: Optional[DescriptionString] = Optional.Absent,
    workGroup: WorkGroupName,
    engineConfiguration: zio.aws.athena.model.EngineConfiguration,
    notebookVersion: Optional[NameString] = Optional.Absent,
    sessionIdleTimeoutInMinutes: Optional[SessionIdleTimeoutInMinutes] =
      Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StartSessionRequest = {
    import StartSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StartSessionRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .engineConfiguration(engineConfiguration.buildAwsValue())
      .optionallyWith(
        notebookVersion.map(value => NameString.unwrap(value): java.lang.String)
      )(_.notebookVersion)
      .optionallyWith(
        sessionIdleTimeoutInMinutes.map(value =>
          SessionIdleTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.sessionIdleTimeoutInMinutes)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.StartSessionRequest.ReadOnly =
    zio.aws.athena.model.StartSessionRequest.wrap(buildAwsValue())
}
object StartSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StartSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StartSessionRequest =
      zio.aws.athena.model.StartSessionRequest(
        description.map(value => value),
        workGroup,
        engineConfiguration.asEditable,
        notebookVersion.map(value => value),
        sessionIdleTimeoutInMinutes.map(value => value),
        clientRequestToken.map(value => value)
      )
    def description: Optional[DescriptionString]
    def workGroup: WorkGroupName
    def engineConfiguration: zio.aws.athena.model.EngineConfiguration.ReadOnly
    def notebookVersion: Optional[NameString]
    def sessionIdleTimeoutInMinutes: Optional[SessionIdleTimeoutInMinutes]
    def clientRequestToken: Optional[IdempotencyToken]
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getEngineConfiguration
        : ZIO[Any, Nothing, zio.aws.athena.model.EngineConfiguration.ReadOnly] =
      ZIO.succeed(engineConfiguration)
    def getNotebookVersion: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("notebookVersion", notebookVersion)
    def getSessionIdleTimeoutInMinutes
        : ZIO[Any, AwsError, SessionIdleTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "sessionIdleTimeoutInMinutes",
        sessionIdleTimeoutInMinutes
      )
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StartSessionRequest
  ) extends zio.aws.athena.model.StartSessionRequest.ReadOnly {
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val engineConfiguration
        : zio.aws.athena.model.EngineConfiguration.ReadOnly =
      zio.aws.athena.model.EngineConfiguration.wrap(impl.engineConfiguration())
    override val notebookVersion: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookVersion())
      .map(value => zio.aws.athena.model.primitives.NameString(value))
    override val sessionIdleTimeoutInMinutes
        : Optional[SessionIdleTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionIdleTimeoutInMinutes())
      .map(value =>
        zio.aws.athena.model.primitives.SessionIdleTimeoutInMinutes(value)
      )
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StartSessionRequest
  ): zio.aws.athena.model.StartSessionRequest.ReadOnly = new Wrapper(impl)
}
