package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  IdempotencyToken,
  CodeBlock,
  DescriptionString,
  SessionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartCalculationExecutionRequest(
    sessionId: SessionId,
    description: Optional[DescriptionString] = Optional.Absent,
    calculationConfiguration: Optional[
      zio.aws.athena.model.CalculationConfiguration
    ] = Optional.Absent,
    codeBlock: Optional[CodeBlock] = Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest = {
    import StartCalculationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        calculationConfiguration.map(value => value.buildAwsValue())
      )(_.calculationConfiguration)
      .optionallyWith(
        codeBlock.map(value => CodeBlock.unwrap(value): java.lang.String)
      )(_.codeBlock)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.StartCalculationExecutionRequest.ReadOnly =
    zio.aws.athena.model.StartCalculationExecutionRequest.wrap(buildAwsValue())
}
object StartCalculationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StartCalculationExecutionRequest =
      zio.aws.athena.model.StartCalculationExecutionRequest(
        sessionId,
        description.map(value => value),
        calculationConfiguration.map(value => value.asEditable),
        codeBlock.map(value => value),
        clientRequestToken.map(value => value)
      )
    def sessionId: SessionId
    def description: Optional[DescriptionString]
    def calculationConfiguration
        : Optional[zio.aws.athena.model.CalculationConfiguration.ReadOnly]
    def codeBlock: Optional[CodeBlock]
    def clientRequestToken: Optional[IdempotencyToken]
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getCalculationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.CalculationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "calculationConfiguration",
      calculationConfiguration
    )
    def getCodeBlock: ZIO[Any, AwsError, CodeBlock] =
      AwsError.unwrapOptionField("codeBlock", codeBlock)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest
  ) extends zio.aws.athena.model.StartCalculationExecutionRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val calculationConfiguration
        : Optional[zio.aws.athena.model.CalculationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculationConfiguration())
        .map(value => zio.aws.athena.model.CalculationConfiguration.wrap(value))
    override val codeBlock: Optional[CodeBlock] = zio.aws.core.internal
      .optionalFromNullable(impl.codeBlock())
      .map(value => zio.aws.athena.model.primitives.CodeBlock(value))
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest
  ): zio.aws.athena.model.StartCalculationExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
