package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait SessionState {
  def unwrap: software.amazon.awssdk.services.athena.model.SessionState
}
object SessionState {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.SessionState
  ): zio.aws.athena.model.SessionState = value match {
    case software.amazon.awssdk.services.athena.model.SessionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.SessionState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.athena.model.SessionState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.athena.model.SessionState.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.athena.model.SessionState.BUSY =>
      val r = BUSY
      r
    case software.amazon.awssdk.services.athena.model.SessionState.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.athena.model.SessionState.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.athena.model.SessionState.DEGRADED =>
      val r = DEGRADED
      r
    case software.amazon.awssdk.services.athena.model.SessionState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.CREATING
  }
  case object CREATED extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.CREATED
  }
  case object IDLE extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.IDLE
  }
  case object BUSY extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.BUSY
  }
  case object TERMINATING extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.TERMINATING
  }
  case object TERMINATED extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.TERMINATED
  }
  case object DEGRADED extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.DEGRADED
  }
  case object FAILED extends zio.aws.athena.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.SessionState =
      software.amazon.awssdk.services.athena.model.SessionState.FAILED
  }
}
