package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{Token, MaxApplicationDPUSizesCount}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListApplicationDpuSizesRequest(
    maxResults: Optional[MaxApplicationDPUSizesCount] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest = {
    import ListApplicationDpuSizesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          MaxApplicationDPUSizesCount.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListApplicationDpuSizesRequest.ReadOnly =
    zio.aws.athena.model.ListApplicationDpuSizesRequest.wrap(buildAwsValue())
}
object ListApplicationDpuSizesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListApplicationDpuSizesRequest =
      zio.aws.athena.model.ListApplicationDpuSizesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxApplicationDPUSizesCount]
    def nextToken: Optional[Token]
    def getMaxResults: ZIO[Any, AwsError, MaxApplicationDPUSizesCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest
  ) extends zio.aws.athena.model.ListApplicationDpuSizesRequest.ReadOnly {
    override val maxResults: Optional[MaxApplicationDPUSizesCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxApplicationDPUSizesCount(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest
  ): zio.aws.athena.model.ListApplicationDpuSizesRequest.ReadOnly = new Wrapper(
    impl
  )
}
