package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQueryResultsResponse(
    updateCount: Optional[Long] = Optional.Absent,
    resultSet: Optional[zio.aws.athena.model.ResultSet] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetQueryResultsResponse = {
    import GetQueryResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
      .builder()
      .optionallyWith(updateCount.map(value => value: java.lang.Long))(
        _.updateCount
      )
      .optionallyWith(resultSet.map(value => value.buildAwsValue()))(
        _.resultSet
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetQueryResultsResponse.ReadOnly =
    zio.aws.athena.model.GetQueryResultsResponse.wrap(buildAwsValue())
}
object GetQueryResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetQueryResultsResponse =
      zio.aws.athena.model.GetQueryResultsResponse(
        updateCount.map(value => value),
        resultSet.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def updateCount: Optional[Long]
    def resultSet: Optional[zio.aws.athena.model.ResultSet.ReadOnly]
    def nextToken: Optional[Token]
    def getUpdateCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("updateCount", updateCount)
    def getResultSet
        : ZIO[Any, AwsError, zio.aws.athena.model.ResultSet.ReadOnly] =
      AwsError.unwrapOptionField("resultSet", resultSet)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
  ) extends zio.aws.athena.model.GetQueryResultsResponse.ReadOnly {
    override val updateCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.updateCount())
      .map(value => value: Long)
    override val resultSet: Optional[zio.aws.athena.model.ResultSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultSet())
        .map(value => zio.aws.athena.model.ResultSet.wrap(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
  ): zio.aws.athena.model.GetQueryResultsResponse.ReadOnly = new Wrapper(impl)
}
