package zio.aws.athena.model
import zio.aws.athena.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreatePresignedNotebookUrlRequest(sessionId: SessionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest = {
    import CreatePresignedNotebookUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.CreatePresignedNotebookUrlRequest.ReadOnly =
    zio.aws.athena.model.CreatePresignedNotebookUrlRequest.wrap(buildAwsValue())
}
object CreatePresignedNotebookUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreatePresignedNotebookUrlRequest =
      zio.aws.athena.model.CreatePresignedNotebookUrlRequest(sessionId)
    def sessionId: SessionId
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest
  ) extends zio.aws.athena.model.CreatePresignedNotebookUrlRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest
  ): zio.aws.athena.model.CreatePresignedNotebookUrlRequest.ReadOnly =
    new Wrapper(impl)
}
