package zio.aws.athena.model
import zio.aws.athena.model.primitives.{CalculationResultType, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CalculationResult(
    stdOutS3Uri: Optional[S3Uri] = Optional.Absent,
    stdErrorS3Uri: Optional[S3Uri] = Optional.Absent,
    resultS3Uri: Optional[S3Uri] = Optional.Absent,
    resultType: Optional[CalculationResultType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CalculationResult = {
    import CalculationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CalculationResult
      .builder()
      .optionallyWith(
        stdOutS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.stdOutS3Uri)
      .optionallyWith(
        stdErrorS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.stdErrorS3Uri)
      .optionallyWith(
        resultS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.resultS3Uri)
      .optionallyWith(
        resultType.map(value =>
          CalculationResultType.unwrap(value): java.lang.String
        )
      )(_.resultType)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CalculationResult.ReadOnly =
    zio.aws.athena.model.CalculationResult.wrap(buildAwsValue())
}
object CalculationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CalculationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CalculationResult =
      zio.aws.athena.model.CalculationResult(
        stdOutS3Uri.map(value => value),
        stdErrorS3Uri.map(value => value),
        resultS3Uri.map(value => value),
        resultType.map(value => value)
      )
    def stdOutS3Uri: Optional[S3Uri]
    def stdErrorS3Uri: Optional[S3Uri]
    def resultS3Uri: Optional[S3Uri]
    def resultType: Optional[CalculationResultType]
    def getStdOutS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("stdOutS3Uri", stdOutS3Uri)
    def getStdErrorS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("stdErrorS3Uri", stdErrorS3Uri)
    def getResultS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("resultS3Uri", resultS3Uri)
    def getResultType: ZIO[Any, AwsError, CalculationResultType] =
      AwsError.unwrapOptionField("resultType", resultType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CalculationResult
  ) extends zio.aws.athena.model.CalculationResult.ReadOnly {
    override val stdOutS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.stdOutS3Uri())
      .map(value => zio.aws.athena.model.primitives.S3Uri(value))
    override val stdErrorS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.stdErrorS3Uri())
      .map(value => zio.aws.athena.model.primitives.S3Uri(value))
    override val resultS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.resultS3Uri())
      .map(value => zio.aws.athena.model.primitives.S3Uri(value))
    override val resultType: Optional[CalculationResultType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultType())
        .map(value =>
          zio.aws.athena.model.primitives.CalculationResultType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CalculationResult
  ): zio.aws.athena.model.CalculationResult.ReadOnly = new Wrapper(impl)
}
