package zio.aws.athena.model
import zio.aws.athena.model.primitives.CodeBlock
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CalculationConfiguration(
    codeBlock: Optional[CodeBlock] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CalculationConfiguration = {
    import CalculationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CalculationConfiguration
      .builder()
      .optionallyWith(
        codeBlock.map(value => CodeBlock.unwrap(value): java.lang.String)
      )(_.codeBlock)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CalculationConfiguration.ReadOnly =
    zio.aws.athena.model.CalculationConfiguration.wrap(buildAwsValue())
}
object CalculationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CalculationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CalculationConfiguration =
      zio.aws.athena.model
        .CalculationConfiguration(codeBlock.map(value => value))
    def codeBlock: Optional[CodeBlock]
    def getCodeBlock: ZIO[Any, AwsError, CodeBlock] =
      AwsError.unwrapOptionField("codeBlock", codeBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CalculationConfiguration
  ) extends zio.aws.athena.model.CalculationConfiguration.ReadOnly {
    override val codeBlock: Optional[CodeBlock] = zio.aws.core.internal
      .optionalFromNullable(impl.codeBlock())
      .map(value => zio.aws.athena.model.primitives.CodeBlock(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CalculationConfiguration
  ): zio.aws.athena.model.CalculationConfiguration.ReadOnly = new Wrapper(impl)
}
