package zio.aws.athena.model
import zio.aws.athena.model.primitives.{ResultOutputLocation, RoleArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SessionConfiguration(
    executionRole: Optional[RoleArn] = Optional.Absent,
    workingDirectory: Optional[ResultOutputLocation] = Optional.Absent,
    idleTimeoutSeconds: Optional[Long] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.athena.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.SessionConfiguration = {
    import SessionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.SessionConfiguration
      .builder()
      .optionallyWith(
        executionRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRole)
      .optionallyWith(
        workingDirectory.map(value =>
          ResultOutputLocation.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .optionallyWith(idleTimeoutSeconds.map(value => value: java.lang.Long))(
        _.idleTimeoutSeconds
      )
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.SessionConfiguration.ReadOnly =
    zio.aws.athena.model.SessionConfiguration.wrap(buildAwsValue())
}
object SessionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.SessionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.SessionConfiguration =
      zio.aws.athena.model.SessionConfiguration(
        executionRole.map(value => value),
        workingDirectory.map(value => value),
        idleTimeoutSeconds.map(value => value),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def executionRole: Optional[RoleArn]
    def workingDirectory: Optional[ResultOutputLocation]
    def idleTimeoutSeconds: Optional[Long]
    def encryptionConfiguration
        : Optional[zio.aws.athena.model.EncryptionConfiguration.ReadOnly]
    def getExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getWorkingDirectory: ZIO[Any, AwsError, ResultOutputLocation] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getIdleTimeoutSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("idleTimeoutSeconds", idleTimeoutSeconds)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.SessionConfiguration
  ) extends zio.aws.athena.model.SessionConfiguration.ReadOnly {
    override val executionRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.athena.model.primitives.RoleArn(value))
    override val workingDirectory: Optional[ResultOutputLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingDirectory())
        .map(value =>
          zio.aws.athena.model.primitives.ResultOutputLocation(value)
        )
    override val idleTimeoutSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.idleTimeoutSeconds())
      .map(value => value: Long)
    override val encryptionConfiguration
        : Optional[zio.aws.athena.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.athena.model.EncryptionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.SessionConfiguration
  ): zio.aws.athena.model.SessionConfiguration.ReadOnly = new Wrapper(impl)
}
