package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ClientRequestToken,
  Payload,
  NotebookName,
  WorkGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportNotebookRequest(
    workGroup: WorkGroupName,
    name: NotebookName,
    payload: Payload,
    `type`: zio.aws.athena.model.NotebookType,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ImportNotebookRequest = {
    import ImportNotebookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ImportNotebookRequest
      .builder()
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .name(NotebookName.unwrap(name): java.lang.String)
      .payload(Payload.unwrap(payload): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ImportNotebookRequest.ReadOnly =
    zio.aws.athena.model.ImportNotebookRequest.wrap(buildAwsValue())
}
object ImportNotebookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ImportNotebookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ImportNotebookRequest =
      zio.aws.athena.model.ImportNotebookRequest(
        workGroup,
        name,
        payload,
        `type`,
        clientRequestToken.map(value => value)
      )
    def workGroup: WorkGroupName
    def name: NotebookName
    def payload: Payload
    def `type`: zio.aws.athena.model.NotebookType
    def clientRequestToken: Optional[ClientRequestToken]
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getName: ZIO[Any, Nothing, NotebookName] = ZIO.succeed(name)
    def getPayload: ZIO[Any, Nothing, Payload] = ZIO.succeed(payload)
    def getType: ZIO[Any, Nothing, zio.aws.athena.model.NotebookType] =
      ZIO.succeed(`type`)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ImportNotebookRequest
  ) extends zio.aws.athena.model.ImportNotebookRequest.ReadOnly {
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val name: NotebookName =
      zio.aws.athena.model.primitives.NotebookName(impl.name())
    override val payload: Payload =
      zio.aws.athena.model.primitives.Payload(impl.payload())
    override val `type`: zio.aws.athena.model.NotebookType =
      zio.aws.athena.model.NotebookType.wrap(impl.`type`())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ImportNotebookRequest
  ): zio.aws.athena.model.ImportNotebookRequest.ReadOnly = new Wrapper(impl)
}
