package zio.aws.athena.model
import zio.aws.athena.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSessionStatusResponse(
    sessionId: Optional[SessionId] = Optional.Absent,
    status: Optional[zio.aws.athena.model.SessionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetSessionStatusResponse = {
    import GetSessionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetSessionStatusResponse
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetSessionStatusResponse.ReadOnly =
    zio.aws.athena.model.GetSessionStatusResponse.wrap(buildAwsValue())
}
object GetSessionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetSessionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetSessionStatusResponse =
      zio.aws.athena.model.GetSessionStatusResponse(
        sessionId.map(value => value),
        status.map(value => value.asEditable)
      )
    def sessionId: Optional[SessionId]
    def status: Optional[zio.aws.athena.model.SessionStatus.ReadOnly]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.athena.model.SessionStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetSessionStatusResponse
  ) extends zio.aws.athena.model.GetSessionStatusResponse.ReadOnly {
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.athena.model.primitives.SessionId(value))
    override val status: Optional[zio.aws.athena.model.SessionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.athena.model.SessionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetSessionStatusResponse
  ): zio.aws.athena.model.GetSessionStatusResponse.ReadOnly = new Wrapper(impl)
}
