package zio.aws.athena.model
import zio.aws.athena.model.primitives.CalculationExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCalculationExecutionCodeRequest(
    calculationExecutionId: CalculationExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest = {
    import GetCalculationExecutionCodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest
      .builder()
      .calculationExecutionId(
        CalculationExecutionId.unwrap(calculationExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetCalculationExecutionCodeRequest.ReadOnly =
    zio.aws.athena.model.GetCalculationExecutionCodeRequest
      .wrap(buildAwsValue())
}
object GetCalculationExecutionCodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCalculationExecutionCodeRequest =
      zio.aws.athena.model
        .GetCalculationExecutionCodeRequest(calculationExecutionId)
    def calculationExecutionId: CalculationExecutionId
    def getCalculationExecutionId: ZIO[Any, Nothing, CalculationExecutionId] =
      ZIO.succeed(calculationExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest
  ) extends zio.aws.athena.model.GetCalculationExecutionCodeRequest.ReadOnly {
    override val calculationExecutionId: CalculationExecutionId =
      zio.aws.athena.model.primitives
        .CalculationExecutionId(impl.calculationExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest
  ): zio.aws.athena.model.GetCalculationExecutionCodeRequest.ReadOnly =
    new Wrapper(impl)
}
