package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ClientRequestToken,
  NotebookName,
  WorkGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNotebookRequest(
    workGroup: WorkGroupName,
    name: NotebookName,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreateNotebookRequest = {
    import CreateNotebookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreateNotebookRequest
      .builder()
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .name(NotebookName.unwrap(name): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CreateNotebookRequest.ReadOnly =
    zio.aws.athena.model.CreateNotebookRequest.wrap(buildAwsValue())
}
object CreateNotebookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreateNotebookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreateNotebookRequest =
      zio.aws.athena.model.CreateNotebookRequest(
        workGroup,
        name,
        clientRequestToken.map(value => value)
      )
    def workGroup: WorkGroupName
    def name: NotebookName
    def clientRequestToken: Optional[ClientRequestToken]
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getName: ZIO[Any, Nothing, NotebookName] = ZIO.succeed(name)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreateNotebookRequest
  ) extends zio.aws.athena.model.CreateNotebookRequest.ReadOnly {
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val name: NotebookName =
      zio.aws.athena.model.primitives.NotebookName(impl.name())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreateNotebookRequest
  ): zio.aws.athena.model.CreateNotebookRequest.ReadOnly = new Wrapper(impl)
}
