package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  Date,
  WorkGroupDescriptionString,
  WorkGroupName
}
import scala.jdk.CollectionConverters.*
final case class WorkGroupSummary(
    name: Optional[WorkGroupName] = Optional.Absent,
    state: Optional[zio.aws.athena.model.WorkGroupState] = Optional.Absent,
    description: Optional[WorkGroupDescriptionString] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent,
    engineVersion: Optional[zio.aws.athena.model.EngineVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.WorkGroupSummary = {
    import WorkGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.WorkGroupSummary
      .builder()
      .optionallyWith(
        name.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          WorkGroupDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.WorkGroupSummary.ReadOnly =
    zio.aws.athena.model.WorkGroupSummary.wrap(buildAwsValue())
}
object WorkGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.WorkGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.WorkGroupSummary =
      zio.aws.athena.model.WorkGroupSummary(
        name.map(value => value),
        state.map(value => value),
        description.map(value => value),
        creationTime.map(value => value),
        engineVersion.map(value => value.asEditable)
      )
    def name: Optional[WorkGroupName]
    def state: Optional[zio.aws.athena.model.WorkGroupState]
    def description: Optional[WorkGroupDescriptionString]
    def creationTime: Optional[Date]
    def engineVersion: Optional[zio.aws.athena.model.EngineVersion.ReadOnly]
    def getName: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.WorkGroupState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, WorkGroupDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupSummary
  ) extends zio.aws.athena.model.WorkGroupSummary.ReadOnly {
    override val name: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val state: Optional[zio.aws.athena.model.WorkGroupState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.athena.model.WorkGroupState.wrap(value))
    override val description: Optional[WorkGroupDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.athena.model.primitives.WorkGroupDescriptionString(value)
        )
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val engineVersion
        : Optional[zio.aws.athena.model.EngineVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersion())
        .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupSummary
  ): zio.aws.athena.model.WorkGroupSummary.ReadOnly = new Wrapper(impl)
}
