package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryExecutionStatistics(
    engineExecutionTimeInMillis: Optional[Long] = Optional.Absent,
    dataScannedInBytes: Optional[Long] = Optional.Absent,
    dataManifestLocation: Optional[String] = Optional.Absent,
    totalExecutionTimeInMillis: Optional[Long] = Optional.Absent,
    queryQueueTimeInMillis: Optional[Long] = Optional.Absent,
    queryPlanningTimeInMillis: Optional[Long] = Optional.Absent,
    serviceProcessingTimeInMillis: Optional[Long] = Optional.Absent,
    resultReuseInformation: Optional[
      zio.aws.athena.model.ResultReuseInformation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryExecutionStatistics = {
    import QueryExecutionStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
      .builder()
      .optionallyWith(
        engineExecutionTimeInMillis.map(value => value: java.lang.Long)
      )(_.engineExecutionTimeInMillis)
      .optionallyWith(dataScannedInBytes.map(value => value: java.lang.Long))(
        _.dataScannedInBytes
      )
      .optionallyWith(
        dataManifestLocation.map(value => value: java.lang.String)
      )(_.dataManifestLocation)
      .optionallyWith(
        totalExecutionTimeInMillis.map(value => value: java.lang.Long)
      )(_.totalExecutionTimeInMillis)
      .optionallyWith(
        queryQueueTimeInMillis.map(value => value: java.lang.Long)
      )(_.queryQueueTimeInMillis)
      .optionallyWith(
        queryPlanningTimeInMillis.map(value => value: java.lang.Long)
      )(_.queryPlanningTimeInMillis)
      .optionallyWith(
        serviceProcessingTimeInMillis.map(value => value: java.lang.Long)
      )(_.serviceProcessingTimeInMillis)
      .optionallyWith(
        resultReuseInformation.map(value => value.buildAwsValue())
      )(_.resultReuseInformation)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryExecutionStatistics.ReadOnly =
    zio.aws.athena.model.QueryExecutionStatistics.wrap(buildAwsValue())
}
object QueryExecutionStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryExecutionStatistics =
      zio.aws.athena.model.QueryExecutionStatistics(
        engineExecutionTimeInMillis.map(value => value),
        dataScannedInBytes.map(value => value),
        dataManifestLocation.map(value => value),
        totalExecutionTimeInMillis.map(value => value),
        queryQueueTimeInMillis.map(value => value),
        queryPlanningTimeInMillis.map(value => value),
        serviceProcessingTimeInMillis.map(value => value),
        resultReuseInformation.map(value => value.asEditable)
      )
    def engineExecutionTimeInMillis: Optional[Long]
    def dataScannedInBytes: Optional[Long]
    def dataManifestLocation: Optional[String]
    def totalExecutionTimeInMillis: Optional[Long]
    def queryQueueTimeInMillis: Optional[Long]
    def queryPlanningTimeInMillis: Optional[Long]
    def serviceProcessingTimeInMillis: Optional[Long]
    def resultReuseInformation
        : Optional[zio.aws.athena.model.ResultReuseInformation.ReadOnly]
    def getEngineExecutionTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "engineExecutionTimeInMillis",
        engineExecutionTimeInMillis
      )
    def getDataScannedInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataScannedInBytes", dataScannedInBytes)
    def getDataManifestLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataManifestLocation", dataManifestLocation)
    def getTotalExecutionTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "totalExecutionTimeInMillis",
        totalExecutionTimeInMillis
      )
    def getQueryQueueTimeInMillis: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("queryQueueTimeInMillis", queryQueueTimeInMillis)
    def getQueryPlanningTimeInMillis: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("queryPlanningTimeInMillis", queryPlanningTimeInMillis)
    def getServiceProcessingTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "serviceProcessingTimeInMillis",
        serviceProcessingTimeInMillis
      )
    def getResultReuseInformation: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultReuseInformation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resultReuseInformation",
      resultReuseInformation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
  ) extends zio.aws.athena.model.QueryExecutionStatistics.ReadOnly {
    override val engineExecutionTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineExecutionTimeInMillis())
        .map(value => value: Long)
    override val dataScannedInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dataScannedInBytes())
      .map(value => value: Long)
    override val dataManifestLocation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataManifestLocation())
      .map(value => value: String)
    override val totalExecutionTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalExecutionTimeInMillis())
        .map(value => value: Long)
    override val queryQueueTimeInMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.queryQueueTimeInMillis())
      .map(value => value: Long)
    override val queryPlanningTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryPlanningTimeInMillis())
        .map(value => value: Long)
    override val serviceProcessingTimeInMillis: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceProcessingTimeInMillis())
        .map(value => value: Long)
    override val resultReuseInformation
        : Optional[zio.aws.athena.model.ResultReuseInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultReuseInformation())
        .map(value => zio.aws.athena.model.ResultReuseInformation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
  ): zio.aws.athena.model.QueryExecutionStatistics.ReadOnly = new Wrapper(impl)
}
