package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  Date,
  WorkGroupName,
  NotebookName,
  NotebookId
}
import scala.jdk.CollectionConverters.*
final case class NotebookMetadata(
    notebookId: Optional[NotebookId] = Optional.Absent,
    name: Optional[NotebookName] = Optional.Absent,
    workGroup: Optional[WorkGroupName] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent,
    `type`: Optional[zio.aws.athena.model.NotebookType] = Optional.Absent,
    lastModifiedTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.NotebookMetadata = {
    import NotebookMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.NotebookMetadata
      .builder()
      .optionallyWith(
        notebookId.map(value => NotebookId.unwrap(value): java.lang.String)
      )(_.notebookId)
      .optionallyWith(
        name.map(value => NotebookName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        lastModifiedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.NotebookMetadata.ReadOnly =
    zio.aws.athena.model.NotebookMetadata.wrap(buildAwsValue())
}
object NotebookMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.NotebookMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.NotebookMetadata =
      zio.aws.athena.model.NotebookMetadata(
        notebookId.map(value => value),
        name.map(value => value),
        workGroup.map(value => value),
        creationTime.map(value => value),
        `type`.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def notebookId: Optional[NotebookId]
    def name: Optional[NotebookName]
    def workGroup: Optional[WorkGroupName]
    def creationTime: Optional[Date]
    def `type`: Optional[zio.aws.athena.model.NotebookType]
    def lastModifiedTime: Optional[Date]
    def getNotebookId: ZIO[Any, AwsError, NotebookId] =
      AwsError.unwrapOptionField("notebookId", notebookId)
    def getName: ZIO[Any, AwsError, NotebookName] =
      AwsError.unwrapOptionField("name", name)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getType: ZIO[Any, AwsError, zio.aws.athena.model.NotebookType] =
      AwsError.unwrapOptionField("type", `type`)
    def getLastModifiedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.NotebookMetadata
  ) extends zio.aws.athena.model.NotebookMetadata.ReadOnly {
    override val notebookId: Optional[NotebookId] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookId())
      .map(value => zio.aws.athena.model.primitives.NotebookId(value))
    override val name: Optional[NotebookName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.athena.model.primitives.NotebookName(value))
    override val workGroup: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val `type`: Optional[zio.aws.athena.model.NotebookType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.athena.model.NotebookType.wrap(value))
    override val lastModifiedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.NotebookMetadata
  ): zio.aws.athena.model.NotebookMetadata.ReadOnly = new Wrapper(impl)
}
