package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  MaxPreparedStatementsCount,
  Token,
  WorkGroupName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPreparedStatementsRequest(
    workGroup: WorkGroupName,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxPreparedStatementsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest = {
    import ListPreparedStatementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest
      .builder()
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxPreparedStatementsCount.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListPreparedStatementsRequest.ReadOnly =
    zio.aws.athena.model.ListPreparedStatementsRequest.wrap(buildAwsValue())
}
object ListPreparedStatementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListPreparedStatementsRequest =
      zio.aws.athena.model.ListPreparedStatementsRequest(
        workGroup,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def workGroup: WorkGroupName
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxPreparedStatementsCount]
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxPreparedStatementsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest
  ) extends zio.aws.athena.model.ListPreparedStatementsRequest.ReadOnly {
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxPreparedStatementsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxPreparedStatementsCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest
  ): zio.aws.athena.model.ListPreparedStatementsRequest.ReadOnly = new Wrapper(
    impl
  )
}
